/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorRoute;
import filenet.sim.toolkit.viewer.VWSIMAnimatorScenario;
import filenet.sim.toolkit.viewer.VWSIMAnimatorStep;
import filenet.sim.toolkit.viewer.VWSIMAnimatorWorkflow;
import filenet.sim.toolkit.viewer.resources.VWSIMResource;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;

public class VWSIMAnimatorMap {
    private VWSIMAnimatorScenario m_scenario = null;
    private VWMapDefinition m_mapDefinition = null;
    private VWSIMAnimatorWorkflow m_workflow = null;
    private String m_name = null;
    private int m_mapId = -1;
    private boolean m_bSelected = false;
    private Vector m_steps = null;
    private Vector m_routes = null;
    private boolean m_bMainMap = false;
    private Vector m_parentMaps = null;
    private Vector m_callingSteps = null;

    public VWSIMAnimatorMap(VWSIMAnimatorWorkflow workflow, VWMapDefinition mapDefinition, boolean bMainMap) throws Exception {
        this.m_workflow = workflow;
        if (workflow != null) {
            this.m_scenario = workflow.getScenario();
        }
        this.m_mapDefinition = mapDefinition;
        if (this.m_mapDefinition != null) {
            this.m_name = this.m_mapDefinition.getName();
            this.m_mapId = this.m_mapDefinition.getMapId();
        }
        this.m_bMainMap = bMainMap;
    }

    void initStepDefinition() throws Exception {
        if (this.m_mapDefinition == null) {
            return;
        }
        this.m_steps = new Vector();
        this.m_routes = new Vector();
        try {
            boolean dataIndex = false;
            VWMapNode[] vwMapNodes = this.m_mapDefinition.getSteps();
            if (vwMapNodes != null) {
                for (int index = 0; index < vwMapNodes.length; ++index) {
                    VWSIMAnimatorRoute route;
                    int rIndex;
                    if (vwMapNodes[index] == null) continue;
                    if (vwMapNodes[index] instanceof VWStepDefinition) {
                        String queueName;
                        VWStepDefinition stepDef = (VWStepDefinition)vwMapNodes[index];
                        int stepType = VWStepUtils.getStepType(vwMapNodes[index]);
                        if ((stepType == 4 || stepType == 3 || stepType == 2 || stepType == 1) && (queueName = stepDef.getQueueName()) != null && this.m_scenario.findQueue(queueName) == null) {
                            this.m_scenario.newQueue(queueName);
                        }
                    }
                    VWSIMAnimatorStep step = new VWSIMAnimatorStep(this, vwMapNodes[index]);
                    this.m_steps.addElement(step);
                    VWRouteDefinition[] vwRoutes = vwMapNodes[index].getNextRoutes();
                    if (vwRoutes != null) {
                        for (rIndex = 0; rIndex < vwRoutes.length; ++rIndex) {
                            route = this.findRoute(vwRoutes[rIndex].getRouteId());
                            if (route == null) {
                                route = new VWSIMAnimatorRoute(vwRoutes[rIndex]);
                                this.m_routes.addElement(route);
                            }
                            route.setPreviousStep(step);
                            step.addNextRoute(route);
                        }
                    }
                    if ((vwRoutes = vwMapNodes[index].getPreviousRoutes()) == null) continue;
                    for (rIndex = 0; rIndex < vwRoutes.length; ++rIndex) {
                        route = this.findRoute(vwRoutes[rIndex].getRouteId());
                        if (route == null) {
                            route = new VWSIMAnimatorRoute(vwRoutes[rIndex]);
                            this.m_routes.addElement(route);
                        }
                        route.setNextStep(step);
                        step.addPreviousRoute(route);
                    }
                }
            }
        }
        catch (VWException e) {
            VWDebug.logException(e);
            throw new Exception(VWSIMResource.s_failedToInitializeStepDefinition);
        }
        this.m_steps = VWSIMAnimatorDataModel.sortSteps(this.m_steps);
        this.m_routes = VWSIMAnimatorDataModel.sortRoutes(this.m_routes);
    }

    public VWSIMAnimatorRoute findRoute(int routeId) {
        if (this.m_routes == null) {
            return null;
        }
        int count = this.m_routes.size();
        if (count == 0) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            VWSIMAnimatorRoute route = (VWSIMAnimatorRoute)this.m_routes.elementAt(i);
            if (route.getRouteId() != routeId) continue;
            return route;
        }
        return null;
    }

    public VWSIMAnimatorStep getStep(int stepId) {
        if (this.m_steps != null) {
            Object obj = null;
            VWSIMAnimatorStep step = null;
            for (int i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorStep) || (step = (VWSIMAnimatorStep)obj).getStepId() != stepId) continue;
                return step;
            }
        }
        return null;
    }

    public VWSIMAnimatorScenario getScenario() {
        return this.m_scenario;
    }

    public VWSIMAnimatorWorkflow getWorkflow() {
        return this.m_workflow;
    }

    public String getWorkflowName() {
        if (this.m_workflow != null) {
            return this.m_workflow.getName();
        }
        return null;
    }

    public String getMapName() {
        if (this.m_mapDefinition != null) {
            return this.m_mapDefinition.getName();
        }
        return this.m_name;
    }

    public int getMapId() {
        return this.m_mapId;
    }

    public Vector getSteps() {
        return this.m_steps;
    }

    public Vector getRoutes() {
        return this.m_routes;
    }

    public VWMapDefinition getMapDefinition() {
        return this.m_mapDefinition;
    }

    protected void addCallingStep(VWSIMAnimatorStep step) {
        if (this.m_callingSteps == null) {
            this.m_callingSteps = new Vector();
        }
        this.m_callingSteps.add(step);
        this.addParentMap(step.getMap());
    }

    public Vector getCallingSteps() {
        if (this.m_callingSteps == null) {
            this.m_callingSteps = new Vector();
        }
        return this.m_callingSteps;
    }

    private void addParentMap(VWSIMAnimatorMap map) {
        VWSIMAnimatorMap firstMap;
        if (map == null) {
            return;
        }
        String mapName = map.getMapName();
        if (mapName == null) {
            return;
        }
        boolean bMainMap = false;
        if (this.m_parentMaps == null) {
            this.m_parentMaps = new Vector();
        } else if (this.m_parentMaps.size() > 0 && (firstMap = (VWSIMAnimatorMap)this.m_parentMaps.elementAt(0)).isMainMap()) {
            bMainMap = true;
        }
        if (map.isMainMap()) {
            if (!bMainMap) {
                this.m_parentMaps.insertElementAt(map, 0);
            }
            return;
        }
        int i = 0;
        if (bMainMap) {
            i = 1;
        }
        while (i < this.m_parentMaps.size()) {
            String name;
            Object obj = this.m_parentMaps.elementAt(i);
            if (obj != null && obj instanceof VWSIMAnimatorMap && (name = ((VWSIMAnimatorMap)obj).getMapName()) != null) {
                int result = VWStringUtils.compare(name, mapName);
                if (result == 0) {
                    return;
                }
                if (result > 0) break;
            }
            ++i;
        }
        this.m_parentMaps.insertElementAt(map, i);
    }

    public Vector getParentMaps() {
        return this.m_parentMaps;
    }

    public boolean isMainMap() {
        return this.m_bMainMap;
    }

    public VWSIMAnimatorStep getLaunchStep() {
        if (this.m_steps != null && this.m_steps.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorStep) || !((VWSIMAnimatorStep)obj).isLaunchStep()) continue;
                return obj;
            }
        }
        return null;
    }

    public String toString() {
        String str = this.getMapName();
        if (str != null) {
            return str;
        }
        return new String("");
    }

    public synchronized void clearStatistics() {
        if (this.m_steps != null && this.m_steps.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorStep)) continue;
                ((VWSIMAnimatorStep)obj).clearStatistics();
            }
        }
    }

    public int getActiveCount() {
        int count = 0;
        if (this.m_steps != null && this.m_steps.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorStep)) continue;
                count += ((VWSIMAnimatorStep)obj).getActiveCount();
            }
        }
        return count;
    }

    public int getCompletedCount() {
        int count = 0;
        if (this.m_steps != null && this.m_steps.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorStep)) continue;
                count += ((VWSIMAnimatorStep)obj).getCompletedCount();
            }
        }
        return count;
    }

    public boolean isSelected() {
        return this.m_bSelected;
    }

    public void setSelected(boolean bSelected) {
        this.m_bSelected = bSelected;
    }

    void releaseResources() {
        int i;
        Object obj = null;
        this.m_scenario = null;
        this.m_mapDefinition = null;
        this.m_workflow = null;
        this.m_name = null;
        if (this.m_steps != null) {
            for (i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorStep)) continue;
                ((VWSIMAnimatorStep)obj).releaseResources();
            }
            this.m_steps.removeAllElements();
            this.m_steps = null;
        }
        if (this.m_routes != null) {
            for (i = 0; i < this.m_routes.size(); ++i) {
                obj = this.m_routes.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorRoute)) continue;
                ((VWSIMAnimatorRoute)obj).releaseResources();
            }
            this.m_routes.removeAllElements();
            this.m_routes = null;
        }
        obj = null;
        if (this.m_parentMaps != null) {
            this.m_parentMaps.removeAllElements();
            this.m_parentMaps = null;
        }
        if (this.m_callingSteps != null) {
            this.m_callingSteps.removeAllElements();
            this.m_callingSteps = null;
        }
    }
}

